#include <windows.h>
#include <stdio.h>
#include <d3dx9.h>
#include <time.h>


#pragma comment(lib, "d3d9.lib")
#pragma comment(lib, "d3dx9.lib")
#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "winmm.lib")


//Bullet̃bsONX̃CN[h
#include "BulletWorld.h"
#include "RigidBody.h"


//tXN[1ɂ
#define	FULLSCREEN 0
//Width
#define	SCRW 640
//Height
#define	SCRH 480


//Direct3DC^[tFCX
LPDIRECT3D9 lpD3D ;
//Direct3DDeviceC^[tFCX
LPDIRECT3DDEVICE9 lpD3DDevice ;


LPDIRECT3DSURFACE9 lpBackbuffer ;
D3DPRESENT_PARAMETERS d3dpp ;

int adapter ;

//Bullet̃[hbsONX
CBulletWorld bulletWorld ;


//gp钸_tH[}bg̒`
struct VERTEX{
	D3DXVECTOR3 Pos ;
	D3DCOLOR Color ;
	D3DXVECTOR2 Tex ;
};

struct XFILE{
	//bVpϐ(`\f[^)
	LPD3DXMESH lpMesh ;
	//O[v(}eA)̌
	DWORD NumMaterial ;
	//eO[ṽ}eA
	D3DMATERIAL9 *Mat ;
	//eO[ṽeNX`
	LPDIRECT3DTEXTURE9 *Tex;
};
//錾
//Xt@C
XFILE xBox ;
XFILE xBall ;
XFILE xField ;
XFILE xFieldCol ;
XFILE xChara ;
//Ƌ̐
const unsigned int OBJ_NUM = 50 ;
//
CRigidBody rbBox[OBJ_NUM] ;
CRigidBody rbBall[OBJ_NUM] ;
CRigidBody rbField ;
CRigidBody rbChara ;


#define	FVF_VERTEX (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1)


LRESULT APIENTRY WndFunc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
void LoadText(LPDIRECT3DTEXTURE9 *lpTex, char fname[], int W, int H, D3DCOLOR Color);
void DrawFrame(void);
void UpdateProc(void);
void RenderProc(void);
void LoadMesh(struct XFILE *XFile, char FName[]);
void DrawMesh(struct XFILE *XFile);
void ReleaseMesh(struct XFILE *XFile);


int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpszCmdParam, int nCmdshow)
{
	MSG msg ;

	HWND hwnd ;
	WNDCLASS wc ;
	char szAppName[] = "Generic Game SDK Window" ;


	wc.style         = CS_DBLCLKS;
	wc.lpfnWndProc   = WndFunc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInst;
	wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = szAppName;

	RegisterClass(&wc);

	hwnd = CreateWindowEx(/*WS_EX_TOPMOST,*/0, szAppName, "Direct X",/*WS_VISIBLE|WS_POPUP,*/ WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, SCRW, SCRH, NULL, NULL, hInst, NULL);

	if( !hwnd ){
		return FALSE;
	}

	ShowWindow(hwnd, nCmdshow);
	UpdateWindow(hwnd);
	SetFocus(hwnd);
	if( FULLSCREEN ){
		ShowCursor(FALSE);
	}
	else{
		RECT rc = {0, 0, SCRW, SCRH} ;

		AdjustWindowRect(&rc, WS_OVERLAPPEDWINDOW, FALSE);
		SetWindowPos(hwnd, NULL, 0, 0, rc.right -rc.left, rc.bottom -rc.top, SWP_SHOWWINDOW | SWP_NOMOVE | SWP_NOZORDER);
	}

	//---------------------DirectX Graphics֘A-----------------------

	//Direct3D IuWFNg쐬
	lpD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if( !lpD3D ){
		//IuWFNg쐬s
		MessageBox(NULL, "Direct3D ̍쐬Ɏs܂B", "ERROR", MB_OK | MB_ICONSTOP);
		//I
		return 0;
	}
	//gpA_v^ԍ
	adapter = 0;

	//EChE̍쐬̂ŁADirect3D 
	ZeroMemory(&d3dpp, sizeof(D3DPRESENT_PARAMETERS));
	//Direct3D p[^̐ݒ
	if( FULLSCREEN ){
		//tXN[ : قƂǂ̃A_v^ŃT|[gĂtH[}bggp
//		d3dpp.BackBufferFormat = D3DFMT_R5G6B5;
		d3dpp.BackBufferFormat = D3DFMT_X8R8G8B8;
	}
	else{
		//EChE : ݂̉ʃ[hgp
		D3DDISPLAYMODE disp;
		//݂̉ʃ[h擾
		lpD3D->GetAdapterDisplayMode(adapter, &disp);
		d3dpp.BackBufferFormat = disp.Format;
	}
	//\̈TCY̐ݒ
	d3dpp.BackBufferWidth  = SCRW;
	d3dpp.BackBufferHeight = SCRH;
	d3dpp.SwapEffect       = D3DSWAPEFFECT_FLIP;

	if( ! FULLSCREEN ){
		//EChE[h
		d3dpp.Windowed = 1;
	}

	//Zobt@̎쐬
	d3dpp.EnableAutoDepthStencil = 1;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D16;

	//obNobt@bN\ɂ(GetDC\ɂȂ)
	d3dpp.Flags = D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;

	//foCX̍쐬 - T&L HAL
	if( FAILED(lpD3D->CreateDevice(adapter, D3DDEVTYPE_HAL, hwnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &lpD3DDevice)) ){
		//ŝ HAL Ŏs
		if( FAILED(lpD3D->CreateDevice(adapter, D3DDEVTYPE_HAL, hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &lpD3DDevice)) ){
			//ŝ REF Ŏs
			if( FAILED(lpD3D->CreateDevice(adapter, D3DDEVTYPE_REF, hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &lpD3DDevice)) ){
				//ǎs
				MessageBox(NULL, "DirectX9ł܂B\nΉ̃p\RƎv܂B", "ERROR", MB_OK | MB_ICONSTOP);
				lpD3D->Release( );
				//I
				return 0;
			}
		}
	}

	//_OEXe[gݒ
	//Z obt@L->O֌W̌vZ𐳊mɂĂ
	lpD3DDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
	lpD3DDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);

	//At@ufBOL
	lpD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);

	//At@ufBO@ݒ
	lpD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	lpD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

	//_ÕAt@ľvZ@̐ݒ
	lpD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_MODULATE);
	//eNX`̐Fgp
	lpD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
	//_̐Fgp
	lpD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
	//_O̐F̌vZ@̐ݒ
	lpD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);

	//ʃJO
	lpD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

	//tB^ݒ
	lpD3DDevice->SetSamplerState(0, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR);
	lpD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	lpD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	//Cg
	lpD3DDevice->SetRenderState(D3DRS_LIGHTING, FALSE);

	lpD3DDevice->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &lpBackbuffer);

	//_tH[}bg̐ݒ
	lpD3DDevice->SetFVF(FVF_VERTEX);

	timeBeginPeriod(1);

	//Bullet̃[h쐬
	bulletWorld.CreateWorld(lpD3DDevice);

	//Xt@C̃[h
	LoadMesh(&xBox, "data/box.x");
	LoadMesh(&xBall, "data/ball.x");
	LoadMesh(&xField, "data/map.x");
	LoadMesh(&xFieldCol, "data/mapHit.x");
	LoadMesh(&xChara, "data/Dwarf.x");

	//̍쐬
	btTransform trans ;
	unsigned int i ;

	trans.setIdentity( );
	for( i = 0; i < OBJ_NUM; i ++ ){
		trans.setOrigin(btVector3((i % 10) * 6.0f, (i / 10) * 6.0f, 20.0f));
		rbBox[i].CreateRigidBody(CRigidBody::BASIC_SHAPE_BOX, trans, btVector3(3.0f, 3.0f, 3.0f), 10.0f);
		trans.setOrigin(btVector3((i % 10) * 6.0f, (i / 10) * 6.0f, 40.0f));
		rbBall[i].CreateRigidBody(CRigidBody::BASIC_SHAPE_SPHERE, trans, btVector3(3.0f, 3.0f, 3.0f));
	}
	trans.setOrigin(btVector3(-50.0f, -10.0f, -50.0f));
	rbField.CreateRigidBody(xFieldCol.lpMesh, trans, btVector3(10.0f, 10.0f, 10.0f), 0.0f);

	trans.setOrigin(btVector3(0.0f, 0.0f, 0.0f));
	rbChara.CreateRigidBody(CRigidBody::BASIC_SHAPE_BOX, trans, btVector3(5.0f, 5.0f, 5.0f));
	rbChara.SetKinematic(true);

	//̂[hɓo^
	for( i = 0; i < OBJ_NUM; i ++ ){
		rbBox[i].AppendWorld(bulletWorld.GetWorld( ));
		rbBall[i].AppendWorld(bulletWorld.GetWorld( ));
	}
	rbField.AppendWorld(bulletWorld.GetWorld( ));
	rbChara.AppendWorld(bulletWorld.GetWorld( ));

	while( 1 ){
		if( PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) ){
			if( ! GetMessage(&msg, NULL, 0, 0) ){
				break;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			DrawFrame( );
		}
	}

	//̂[h폜
	for( i = 0; i < OBJ_NUM; i ++ ){
		rbBox[i].RemoveWorld(bulletWorld.GetWorld( ));
		rbBall[i].RemoveWorld(bulletWorld.GetWorld( ));
	}
	rbField.RemoveWorld(bulletWorld.GetWorld( ));
	rbChara.RemoveWorld(bulletWorld.GetWorld( ));

	//̍폜
	for( i = 0; i < OBJ_NUM; i ++ ){
		rbBox[i].DeleteRigidBody( );
		rbBall[i].DeleteRigidBody( );
	}
	rbField.DeleteRigidBody( );
	rbChara.DeleteRigidBody( );

	//Xt@C̉
	ReleaseMesh(&xChara);
	ReleaseMesh(&xFieldCol);
	ReleaseMesh(&xField);
	ReleaseMesh(&xBall);
	ReleaseMesh(&xBox);

	//Bullet̃[h
	bulletWorld.ReleaseWorld( );

	timeEndPeriod(1);


	lpBackbuffer->Release( );

	//Direct3D IuWFNg
	lpD3DDevice->Release( );
	lpD3D->Release( );


	return msg.wParam;
}



LRESULT APIENTRY WndFunc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch( msg ){
		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;

		case WM_KEYDOWN:
			switch( wParam ){
				case VK_ESCAPE:
					PostQuitMessage(0);
					return 0;
			}
		return 0;

	}


	return DefWindowProc(hwnd, msg, wParam, lParam);
}



void LoadText(LPDIRECT3DTEXTURE9 *lpTex, char fname[], int W, int H, D3DCOLOR Color)
{
	if( W == 0 ){
		W = D3DX_DEFAULT;
	}
	if( H == 0 ){
		H = D3DX_DEFAULT;
	}
	D3DXCreateTextureFromFileEx(lpD3DDevice, fname, W, H, 1, 0, D3DFMT_UNKNOWN, D3DPOOL_MANAGED, D3DX_FILTER_NONE, D3DX_DEFAULT, Color, NULL, NULL, lpTex);


	return;
}



void DrawFrame(void)
{
	UpdateProc( );

	//`Jn
	lpD3DDevice->BeginScene( );

	//obNobt@ Z obt@NA
	lpD3DDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 0, 255), 1.0f ,0);

	RenderProc( );

	//`I
	lpD3DDevice->EndScene( );

	//obNobt@vC}obt@ɃRs[
	if( FAILED(lpD3DDevice->Present(NULL, NULL, NULL, NULL)) ){
		lpD3DDevice->Reset(&d3dpp);
	}


	return;
}



void UpdateProc(void)
{
	//V~[Vis
	bulletWorld.StepSimulation(1.0f / 60.0f);

	btTransform trans ;

	//IuWFNgɑ΂鏈
	unsigned int i ;

	//ʒuZbg
	if( GetAsyncKeyState('R') & 0x8000 ){
		trans.setIdentity( );
		for( i = 0; i < OBJ_NUM; i ++ ){
			trans.setOrigin(btVector3((i % 10) * 6.0f, (i / 10) * 6.0f, 20.0f));
			rbBox[i].SetTransform(trans);
			trans.setOrigin(btVector3((i % 10) * 6.0f, (i / 10) * 6.0f, 40.0f));
			rbBall[i].SetTransform(trans);
		}
	}
	//Oɗ͂
	if( GetAsyncKeyState('A') & 0x8000 ){
		for( i = 0; i < OBJ_NUM; i ++ ){
			rbBox[i].SetForce(btVector3(0.0f, 0.0f, 50.0f), btVector3(0.0f, 10.0f, 0.0f));
			rbBall[i].SetForce(btVector3(0.0f, 0.0f, 10.0f));
		}
	}
	//]
	if( GetAsyncKeyState('S') & 0x8000 ){
		for( i = 0; i < OBJ_NUM; i ++ ){
			rbBox[i].SetAngVelocity(btVector3(0.0f, 20.0f, 0.0f));
			rbBall[i].SetAngVelocity(btVector3(10.0f, 0.0f, 0.0f));
		}
	}

	//Lړ
	if( GetAsyncKeyState(VK_UP) & 0x8000 ){
		trans.setIdentity( );
		trans.setOrigin(btVector3(0.0f, 0.0f, rbChara.GetScaling( ).z( ) * 0.3f));
		rbChara.SetTransform(rbChara.GetTransform( ) * trans);
	}
	if( GetAsyncKeyState(VK_LEFT) & 0x8000 ){
		trans.setIdentity( );
		trans.setRotation(btQuaternion(btVector3(0.0f, 1.0f, 0.0f), D3DXToRadian(-3)));
		rbChara.SetTransform(rbChara.GetTransform( ) * trans);
	}
	if( GetAsyncKeyState(VK_RIGHT) & 0x8000 ){
		trans.setIdentity( );
		trans.setRotation(btQuaternion(btVector3(0.0f, 1.0f, 0.0f), D3DXToRadian(3)));
		rbChara.SetTransform(rbChara.GetTransform( ) * trans);
	}

	//
	trans.setIdentity( );
	trans.setOrigin(btVector3(0.0f, -0.98f, 0.0f));
	rbChara.SetTransform(trans * rbChara.GetTransform( ));

	//Cs
	CRayResult rayResult ;
	btTransform charaTrans ;

	//nʔ
	charaTrans = rbChara.GetTransform( );
	trans.setIdentity( );
	trans.setOrigin(btVector3(0.0f, -(rbChara.GetScaling( ).y( ) * 2), 0.0f));
	trans = charaTrans * trans;
	rbField.CollisionToRay(bulletWorld.GetWorld( ), charaTrans, trans, &rayResult);
	if( true == rayResult.hasHit( ) ){
		btVector3 rayFrom, rayTo, hitPoint ;
		float dis ;

		rayFrom = charaTrans.getOrigin( );
		rayTo = trans.getOrigin( );
		hitPoint = rayFrom + (rayTo - rayFrom) * rayResult.m_closestHitFraction;
		dis = (hitPoint - charaTrans.getOrigin( )).length( );
		if( rbChara.GetScaling( ).y( ) >= dis ){
			trans.setIdentity( );
			trans.setOrigin(btVector3(0.0f, (rbChara.GetScaling( ).y( ) - dis), 0.0f));
			rbChara.SetTransform(charaTrans * trans);
		}
	}
	//O
	charaTrans = rbChara.GetTransform( );
	trans.setIdentity( );
	trans.setOrigin(btVector3(0.0f, 0.0f, (rbChara.GetScaling( ).z( ) * 2)));
	trans = charaTrans * trans;
	rbField.CollisionToRay(bulletWorld.GetWorld( ), charaTrans, trans, &rayResult);
	if( true == rayResult.hasHit( ) ){
		btVector3 rayFrom, rayTo, hitPoint ;
		float dis ;
		D3DXVECTOR3 vec ;
		btVector3 normal ;
		float dot, limit ;

		rayFrom = charaTrans.getOrigin( );
		rayTo = trans.getOrigin( );
		hitPoint = rayFrom + (rayTo - rayFrom) * rayResult.m_closestHitFraction;
		dis = (hitPoint - charaTrans.getOrigin( )).length( );

		D3DXVec3TransformNormal(&vec, &D3DXVECTOR3(0.0f, 0.0f, 1.0f), &CBulletWorld::ConvertTransform(charaTrans));
		normal = rayResult.GetNormal( );
		normal.setY(0.0f);
		normal.normalize( );
		dot = D3DXVec3Dot(&CBulletWorld::ConvertVector3(normal), &-vec);
		limit = rbChara.GetScaling( ).z( ) / dot;
		limit = fabs(limit);
		if( dis < limit ){
			trans.setIdentity( );
			trans.setOrigin(normal * ((limit - dis) * dot));
			rbChara.SetTransform(trans * charaTrans);
		}
	}

	D3DXMATRIX mView, mProj ;
	D3DXVECTOR3 eye, at ;

	charaTrans = rbChara.GetTransform( );
	trans.setIdentity( );
	//_s̐ݒ
	at = CBulletWorld::ConvertVector3(charaTrans.getOrigin( ));
	trans.setOrigin(btVector3(0.0f, 15.0f, -30.0f));
	trans = charaTrans * trans;
	eye = CBulletWorld::ConvertVector3(trans.getOrigin( ));
	D3DXMatrixLookAtLH(&mView, &eye, &at, &D3DXVECTOR3(0.0f, 1.0f, 0.0f));
//	D3DXMatrixLookAtLH(&mView, &D3DXVECTOR3(0, 50, -200), &D3DXVECTOR3(0, 0, 0), &D3DXVECTOR3(0.0f, 1.0f, 0.0f));

	//es̐ݒ
	D3DXMatrixPerspectiveFovLH(&mProj, D3DXToRadian(60), 4.0f / 3.0f, 1.0f, 1000.0f);

	//sݒ
	lpD3DDevice->SetTransform(D3DTS_VIEW, &mView);
	lpD3DDevice->SetTransform(D3DTS_PROJECTION, &mProj);


	return;
}



void RenderProc(void)
{
	D3DXMATRIX mWorld, mScal ;
	btVector3 scal ;

	//L̕`
	mWorld = CBulletWorld::ConvertTransform(rbChara.GetTransform( ));
	scal = rbChara.GetScaling( );
	D3DXMatrixScaling(&mScal, scal.x( ), scal.y( ), scal.z( ));
	mWorld = mScal * mWorld;
	lpD3DDevice->SetTransform(D3DTS_WORLD, &mWorld);
	DrawMesh(&xChara);

	//IuWFNg̕`
	unsigned int i ;

	for( i = 0; i < OBJ_NUM; i ++ ){
		//̕`
		mWorld = CBulletWorld::ConvertTransform(rbBox[i].GetTransform( ));
		scal = rbBox[i].GetScaling( );
		D3DXMatrixScaling(&mScal, scal.x( ), scal.y( ), scal.z( ));
		mWorld = mScal * mWorld;
		lpD3DDevice->SetTransform(D3DTS_WORLD, &mWorld);
		DrawMesh(&xBox);
		//̕`
		mWorld = CBulletWorld::ConvertTransform(rbBall[i].GetTransform( ));
		scal = rbBall[i].GetScaling( );
		D3DXMatrixScaling(&mScal, scal.x( ), scal.y( ), scal.z( ));
		mWorld = mScal * mWorld;
		lpD3DDevice->SetTransform(D3DTS_WORLD, &mWorld);
		DrawMesh(&xBall);
	}

	//fobOrĥ݃RpC
#ifdef _DEBUG
	//Bullet̃fobO`s
	{
		DWORD oldState ;

		lpD3DDevice->GetRenderState(D3DRS_LIGHTING, &oldState);
		//CgLȏꍇ͖ɂ
		if( FALSE != oldState ){
			lpD3DDevice->SetRenderState(D3DRS_LIGHTING, FALSE);
		}
		//fobO`s
		bulletWorld.DrawFrame( );
		//Cg𖳌ɂꍇ͖߂Ă
		if( FALSE != oldState ){
			lpD3DDevice->SetRenderState(D3DRS_LIGHTING, oldState);
		}
	}
#endif

	//tB[h̕`(߃eNX`gĂ̂ōŌɕ`)
	mWorld = CBulletWorld::ConvertTransform(rbField.GetTransform( ));
	scal = rbField.GetScaling( );
	D3DXMatrixScaling(&mScal, scal.x( ), scal.y( ), scal.z( ));
	mWorld = mScal * mWorld;
	lpD3DDevice->SetTransform(D3DTS_WORLD, &mWorld);
	//߃eNX`gĂ̂Ń_[Xe[gύX
	lpD3DDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);
	DrawMesh(&xField);
	lpD3DDevice->SetRenderState(D3DRS_ALPHATESTENABLE, TRUE);


	return;
}



void DrawMesh(struct XFILE *XFile)
{
	DWORD i ;


	for( i = 0; i < XFile->NumMaterial; i ++ ){
		lpD3DDevice->SetMaterial(&(XFile->Mat[i]));
		lpD3DDevice->SetTexture(0, XFile->Tex[i]);
		XFile->lpMesh->DrawSubset(i);
		//lpTeaPotƓʒut
	}


	return;
}



void LoadMesh(struct XFILE *XFile, char FName[])
{
	LPD3DXBUFFER lpD3DXBuffer ;


	D3DXLoadMeshFromX(FName, D3DXMESH_MANAGED, lpD3DDevice, NULL, &lpD3DXBuffer, NULL, &(XFile->NumMaterial), &(XFile->lpMesh));

	XFile->Mat = new D3DMATERIAL9[XFile->NumMaterial];
	XFile->Tex = new LPDIRECT3DTEXTURE9[XFile->NumMaterial];

	D3DXMATERIAL* D3DXMat = (D3DXMATERIAL*)lpD3DXBuffer->GetBufferPointer( ) ;

	DWORD i ;

	for( i = 0; i < XFile->NumMaterial; i ++ ){
		XFile->Mat[i] = D3DXMat[i].MatD3D;
		XFile->Mat[i].Ambient = XFile->Mat[i].Diffuse;
		if( FAILED(D3DXCreateTextureFromFile(lpD3DDevice, D3DXMat[i].pTextureFilename, &(XFile->Tex[i]))) ){
			XFile->Tex[i] = NULL;
		}
	}

	lpD3DXBuffer->Release( );


	return;
}



void ReleaseMesh(struct XFILE *XFile)
{
	if( XFile->lpMesh != NULL ){
		DWORD i ;

		delete[] XFile->Mat;
		for( i = 0; i < XFile->NumMaterial; i ++ ){
			if( XFile->Tex[i] != NULL ){
				XFile->Tex[i]->Release( );
				XFile->Tex[i] = NULL;
			}
		}
		delete[] XFile->Tex;
		XFile->lpMesh->Release( );

		XFile->lpMesh = NULL;
	}


	return;
}

